<!-- Main Content -->
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('payment_gateway', "Payment Gateways") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-cog  text-info"></i> </i> <?= labels('settings', 'Settings') ?></a></div>
                <div class="breadcrumb-item"></i> <?= labels('payment_gateways', 'Payment Gateways Settings') ?></div>
            </div>
        </div>
        <form method="POST" action="<?= base_url('admin/settings/pg-settings') ?>">
            <input type="hidden" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">
            <div class="container-fluid card pt-3">

                <!-- Razorpay Payment gateway code start -->

                <h2 class='section-title'><?= labels('razorPay', 'RazorPay') ?></h2>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for='razorpay_status'><?= labels('status', 'Status') ?></label>
                            <select class='form-control selectric' name='razorpayApiStatus' id='razorpay_status'>
                                <option value='enable' <?= isset($razorpayApiStatus) && $razorpayApiStatus === 'enable' ? 'selected' : '' ?>>Enable</option>
                                <option value='disable' <?= isset($razorpayApiStatus) && $razorpayApiStatus === 'disable' ? 'selected' : '' ?>>Disable</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="razorpayMode"><?= labels('mode', 'Mode') ?></label>
                            <select class='form-control selectric' name='razorpay_mode' id='razorpay_mode'>
                                <option value='test' <?= isset($razorpay_mode) && $razorpay_mode === 'test' ? 'selected' : '' ?>>Test</option>
                                <option value='live' <?= isset($razorpay_mode) && $razorpay_mode === 'live' ? 'selected' : '' ?>>Live</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="razorpayMode"><?= labels('currency_code', 'Currency Code') ?></label>
                            <input type="text" value="<?= isset($razorpay_currency) ? $razorpay_currency : '' ?>" name='razorpay_currency' id='razorpay_currency' placeholder='Enter Razorpay currency' class="form-control" />
                        </div>
                    </div>


                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="razorpay_secret"><?= labels('secret_key', 'Secret Key') ?></label>
                            <input type="text" value="<?= isset($razorpay_secret) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $razorpay_secret) : '' ?>" name='razorpay_secret' id='razorpay_secret' placeholder='Enter Razor Pay secret key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="razorpay_key"><?= labels('API_key', 'API Key') ?></label>
                            <input type="text" value="<?= isset($razorpay_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $razorpay_key) : '' ?>" name='razorpay_key' id='razorpay_key' placeholder='Enter Razor Pay API key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endpoint"><?= labels('Payment_endpoint_URL', 'Payment Endpoint URL') ?><small>(<?= labels('set_this_as_endpoint_URL_in_your_razorpay_account', ' Set this as Endpoint URL in your razorpay account') ?>)</small></label>
                            <input type="text" value="<?= base_url("/api/webhooks/razorpay") ?>" name='endpoint' id='endpoint' class="form-control" readonly/>
                        </div>
                    </div>
                </div>
                <!-- <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endpoint">Payment Endpoint URL<small> (Set this as Endpoint URL in your razorpay account)</small></label>
                            <input type="text" value="<?= base_url("/api/webhooks/razorpay") ?>" name='endpoint' id='endpoint' class="form-control" readonly/>
                        </div>
                    </div>
                </div> -->

                <h2 class='section-title'><?= labels('paystack', 'Paystack') ?></h2>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for='paystack_status'><?= labels('status', 'Status') ?></label>
                            <select class='form-control selectric' name='paystack_status' id='paystack_status'>
                                <option value='enable' <?= isset($paystack_status) && $paystack_status === 'enable' ? 'selected' : '' ?>>Enable</option>
                                <option value='disable' <?= isset($paystack_status) && $paystack_status === 'disable' ? 'selected' : '' ?>>Disable</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="paystack_mode"><?= labels('mode', 'Mode') ?></label>
                            <select class='form-control selectric' name='paystack_mode' id='paystack_mode'>
                                <option value='test' <?= isset($paystack_mode) && $paystack_mode === 'test' ? 'selected' : '' ?>>Test</option>
                                <option value='live' <?= isset($paystack_mode) && $paystack_mode === 'live' ? 'selected' : '' ?>>Live</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="razorpayMode"><?= labels('currency_code', 'Currency Code') ?></label>
                            <input type="text" value="<?= isset($paystack_currency) ? $paystack_currency : '' ?>" name='paystack_currency' id='paystack_currency' placeholder='Enter Paystack currency' class="form-control" />
                        </div>
                    </div>


                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="paystack_secret"><?= labels('secret_key', 'Secret Key') ?></label>
                            <input type="text" value="<?= isset($paystack_secret) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $paystack_secret) : '' ?>" name='paystack_secret' id='paystack_secret' placeholder='Enter Razor Pay secret key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="paystack_key"><?= labels('public_key', 'Public Key') ?></label>
                            <input type="text" value="<?= isset($paystack_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $paystack_key) : '' ?>" name='paystack_key' id='paystack_key' placeholder='Enter Razor Pay API key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endpoint"><?= labels('Payment_endpoint_URL', 'Payment Endpoint URL') ?><small> (<?= labels('set_this_as_endpoint_URL_in_your_paystack_account', 'Set this as Endpoint URL in your paystack account') ?>)</small></label>
                            <input type="text" value="<?= base_url("api/webhooks/paystack") ?>" name='endpoint' id='endpoint' class="form-control" readonly/>
                        </div>
                    </div>
                </div>
                <!-- <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endpoint">Payment Endpoint URL<small> (Set this as Endpoint URL in your paystack account)</small></label>
                            <input type="text" value="<?= base_url("api/webhooks/paystack") ?>" name='endpoint' id='endpoint' class="form-control" readonly/>
                        </div>
                    </div>
                </div> -->

                <!-- Razorpay Payment gateway code end -->


                <!-- Flutterwave Payment gateway code start -->

                <!-- <h2 class='section-title'>Flutter wave</h2>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for='flutter_wave_status'>Status</label>
                            <select class='form-control selectric' name='flutter_wave_status' id='flutter_wave_status'>
                                <option value='enable' <?= isset($flutter_wave_status) && $flutter_wave_status === 'enable' ? 'selected' : '' ?>>Enable</option>
                                <option value='disable' <?= isset($flutter_wave_status) && $flutter_wave_status === 'disable' ? 'selected' : '' ?>>Disable</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="flutter_public_key">Public key</label>
                            <input type="text" value="<?= isset($flutter_public_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $flutter_public_key) : '' ?>" name='flutter_public_key' id='flutter_public_key' placeholder='Enter flutter wave public key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="flutter_secret">Secret Key</label>
                            <input type="text" value="<?= isset($flutter_secret) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $flutter_secret) : '' ?>" name='flutter_secret' id='flutter_secret' placeholder='Enter flutter wave secret key' class="form-control" />
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="flutter_encryption_key">Flutterwave Encryption key</label>
                            <input type="text" value="<?= isset($flutter_encryption_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $flutter_encryption_key) : '' ?>" name='flutter_encryption_key' id='flutter_encryption_key' placeholder='Enter flutter encryption key key' class="form-control" />
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="webhook_secret_key">Flutterwave Webhook Secret Key</label>
                            <input type="text" value="<?= isset($webhook_secret_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $webhook_secret_key) : '' ?>" name='webhook_secret_key' id='webhook_secret_key' placeholder='Enter webhook secret key' class="form-control" />
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="form-group">
                            <label for="flutterwave_currency_code">Currency Code <small>[ Flutterwave supported ]</small> </label>
                            <select name="flutterwave_currency_code" class="form-control">
                                <option value="">Select Currency Code </option>
                                <option value="NGN" selected="">Nigerian Naira</option>
                                <option value="USD">United States dollar</option>
                                <option value="TZS">Tanzanian Shilling</option>
                                <option value="SLL">Sierra Leonean Leone</option>
                                <option value="MUR">Mauritian Rupee</option>
                                <option value="MWK">Malawian Kwacha </option>
                                <option value="GBP">UK Bank Accounts</option>
                                <option value="GHS">Ghanaian Cedi</option>
                                <option value="RWF">Rwandan franc</option>
                                <option value="UGX">Ugandan Shilling</option>
                                <option value="ZMW">Zambian Kwacha</option>
                                <option value="KES">Mpesa</option>
                                <option value="ZAR">South African Rand</option>
                                <option value="XAF">Central African CFA franc</option>
                                <option value="XOF">West African CFA franc</option>
                                <option value="AUD">Australian Dollar</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="form-group">
                            <label for="end_point_url">Flutter Wave End Point URl</label>
                            <input id="end_point_url" class="form-control" type="text" value="<?= isset($flutter_wave_end_point_url) ? $flutter_wave_end_point_url : 'Please enter End point URL for Flutter wave' ?>" name="flutter_wave_end_point_url">
                        </div>
                    </div>
                </div> -->
                <!-- Flutterwave Payment gateway code end -->



                <!-- Stripe Payment gateway code start -->
                <div class="container-fluid card pt-3">
                    <h2 class='section-title'><?= labels('stripe', 'Stripe') ?></h2>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for='stripe_status'><?= labels('status', 'Status') ?></label>
                                <select class='form-control selectric' name='stripe_status' id='stripe_status'>
                                    <option value='enable' <?= isset($stripe_status) && $stripe_status === 'enable' ? 'selected' : '' ?>>Enable</option>
                                    <option value='disable' <?= isset($stripe_status) && $stripe_status === 'disable' ? 'selected' : '' ?>>Disable</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="razorpayMode"><?= labels('mode', 'Mode') ?></label>
                                <select class='form-control selectric' name='stripe_mode' id='stripe_mode'>
                                    <option value='test' <?= isset($stripe_mode) && $stripe_mode === 'test' ? 'selected' : '' ?>>Test</option>
                                    <option value='live' <?= isset($stripe_mode) && $stripe_mode === 'live' ? 'selected' : '' ?>>Live</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="razorpayMode"><?= labels('currency_code', 'Currency Code') ?></label>
                                <input type="text" value="<?= isset($stripe_currency) ? $stripe_currency : '' ?>" name='stripe_currency' id='stripe_currency' placeholder='Enter stripe currency' class="form-control" />
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="publishable_key"><?= labels('stripe_publishable_key', 'Stripe Publishable key') ?></label>
                                <input type="text" value="<?= isset($stripe_publishable_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $stripe_publishable_key) : '' ?>" name='stripe_publishable_key' id='stripe_publishable_key' placeholder='Enter Stripe Publishable key' class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="publishable_key"><?= labels('stripe_webhook_secret', 'Stripe Webhook secret') ?></label>
                                <input type="text" value="<?= isset($stripe_webhook_secret_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $stripe_webhook_secret_key) : '' ?>" name='stripe_webhook_secret_key' id='stripe_webhook_secret_key' placeholder='Enter Stripe Publishable key' class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="razorpaySecretKey"><?= labels('stripe_secret_key', 'Stripe Secret key') ?></label>
                                <input type="text" value="<?= isset($stripe_secret_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $stripe_secret_key) : '' ?>" name='stripe_secret_key' id='stripe_secret_key' placeholder='Enter Stripe secret key' class="form-control" />
                            </div>
                        </div>

                    </div>
                    <!-- <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="razorpaySecretKey">Stripe Secret key</label>
                                <input type="text" value="<?= isset($stripe_secret_key) ? ((defined('ALLOW_VIEW_KEYS') && ALLOW_VIEW_KEYS == 0) ? "asc****************adaca" : $stripe_secret_key) : '' ?>" name='stripe_secret_key' id='stripe_secret_key' placeholder='Enter Stripe secret key' class="form-control" />
                            </div>
                        </div>
                    </div> -->
                    <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="endpoint"><?= labels('Payment_endpoint_URL', 'Payment Endpoint URL') ?><small> (<?= labels('set_this_as_endpoint_URL_in_your_stripe_account', 'Set this as Endpoint URL in your stripe account') ?>)</small></label>
                            <input type="text" value="<?= site_url("api/webhooks/stripe") ?>" name='endpoint' id='endpoint' class="form-control" readonly/>
                        </div>
                    </div>
                </div>

                    <div class="row">
                        <div class="col-md">
                            <div class="form-group">
                                <input type='submit' name='update' id='update' value='<?= labels('update', 'Update') ?>' class='btn btn-success' />
                                <input type='reset' name='clear' id='clear' value='<?= labels('Reset', 'Reset') ?>' class='btn btn-danger' />
                            </div>
                        </div>
                    </div>

                </div>

                <!-- Stripe Payment gateway code end -->
        </form>
    </section>
</div>